/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Vec3Helper {
    @Nullable
    public static <T extends Entity> T getPointedEntity(LivingEntity viewer, Level level, int dist, Class<T> tClass, Predicate<? super T> nearByFilter, Predicate<? super T> passFilter) {
        Vec3 playerEyePosition = viewer.m_20299_(1.0f);
        Vec3 playerLook = viewer.m_20252_(1.0f);
        Vec3 eyeSight = playerEyePosition.m_82520_(playerLook.f_82479_ * (double)dist, playerLook.f_82480_ * (double)dist, playerLook.f_82481_ * (double)dist);
        AABB nearByBox = viewer.m_20191_().m_82363_(playerLook.f_82479_ * (double)dist, playerLook.f_82480_ * (double)dist, playerLook.f_82481_ * (double)dist).m_82377_(1.0, 1.0, 1.0);
        Entity pointedEntity = null;
        double currentDist = dist;
        List nearbyEntities = level.m_6443_(tClass, nearByBox, nearByFilter);
        for (Entity nearbyEntity : nearbyEntities) {
            double distanceTo;
            if (nearbyEntity == viewer || passFilter.test(nearbyEntity)) continue;
            AABB axisAlignedBB = nearbyEntity.m_20191_().m_82400_((double)nearbyEntity.m_6143_());
            Optional optional = axisAlignedBB.m_82371_(playerEyePosition, eyeSight);
            if (axisAlignedBB.m_82390_(playerEyePosition)) {
                pointedEntity = nearbyEntity;
                currentDist = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((distanceTo = playerEyePosition.m_82554_((Vec3)optional.get())) < currentDist)) continue;
            currentDist = distanceTo;
            pointedEntity = nearbyEntity;
        }
        return (T)pointedEntity;
    }
}

